﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="System.Globalization" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title></title>
		<script runat="server">

    
    class Element: IComparable {
           readonly string nazwa;
           decimal wpłaty;
           decimal wypłaty;
           public Element(Zaplata z) {
               this.nazwa = z.SposobZaplaty.Nazwa;
           }
           public void Add(Zaplata z) {
               wpłaty += z.Wpłata.Value;
               wypłaty += z.Wypłata.Value;
           }
           public int CompareTo(object v) {
               return string.Compare(Nazwa, ((Element)v).Nazwa, true);
           }
           public string Nazwa {
               get { return nazwa; }
           }
           public decimal Wpłata {
               get { return wpłaty; }
           }
           public decimal Wypłata {
               get { return wypłaty; }
           }
           public decimal Saldo {
               get { return wpłaty-wypłaty; }
           }
       }
    
       class Element2 {
           readonly string nazwa;
           object wpłaty;
           object wypłaty;
           static string marker = " ------------ ";
           public Element2(string nazwa, object wpłaty, object wypłaty) {
               this.nazwa = nazwa;
               this.wpłaty = wpłaty;
               this.wypłaty = wypłaty;
           }
           public string Nazwa {
               get { return nazwa; }
           }
           public object Wpłata {
               get { return wpłaty!=null ? wpłaty : marker; }
           }
           public object Wypłata {
               get { return wypłaty!=null ? wypłaty : marker; }
           }
       }
    
       Hashtable elements = new Hashtable();
       decimal sumWpł = 0;
       decimal sumWypł = 0;
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        Zaplata z = (Zaplata)args.Row;
        if (z.NumeryDokumentow==""||z.Opis.Contains(z.NumeryDokumentow))
            colOpis.EditValue = z.Opis;
        else
            colOpis.EditValue = z.Opis + ", " + z.NumeryDokumentow;

        Element elem = (Element)elements[z.SposobZaplaty];
        if (elem==null) {
            elem = new Element(z);
            elements[z.SposobZaplaty] = elem;
        }
        elem.Add(z);

        sumWpł += z.Wpłata.Value;
        sumWypł += z.Wypłata.Value;
    }


	private string NazwaWieleLinii()
	{
		IPieczątkaFirmy pieczątka = ReportHeader.GetPieczątka( dc, null, false );
		return pieczątka.NazwaFormatowana;
	}
    

    void Grid1_AfterRender(Object sender, EventArgs args) {
        RaportESP raport = (RaportESP)dc[typeof(RaportESP)];
        ArrayList arr = new ArrayList(elements.Values);
        arr.Sort();
        TextGrid2.DataSource = arr;

        Element2[] els = new Element2[3];
        els[0] = new Element2("Obroty", sumWpł, sumWypł);
        els[1] = new Element2("Stan poprzedni", GT(raport.SaldoPoczatkowe.Value), LT(raport.SaldoPoczatkowe.Value));
        els[2] = new Element2("Stan obecny", LT(raport.SaldoKoncowe.Value), GT(raport.SaldoKoncowe.Value));

        TextGrid3.DataSource = els;
       }
    
       object GT(decimal value) {
           if (value>0)
               return value;
           return null;
       }
    
       object LT(decimal value) {
           if (value<0)
               return -value;
           return null;
       }
    
       void OnContextLoad(object sender, EventArgs e) {

			labelCopyright.EditValue = dc.Copyright;
			labelData.EditValue = dc.Session.Login.CurrentDate;
			labelOperator.EditValue = dc.Session.Login.Operator.FullName;
           IdPieczatka.EditValue = NazwaWieleLinii();

			RaportESP raport = (RaportESP)dc[typeof(RaportESP)];
			if (raport.Kasa.Typ!=TypEwidencjiSP.Kasa)
				dlRaport.EditValue = "WYCIĄG BANKOWY";
			else
				dlRaport.EditValue = "RAPORT KASOWY";
       }
    	
		</script>
	</HEAD>
	<body>
		<font face="Courier New" size="smaller">
			<form id="Sprzedaż" method="post" runat="server">
				<P>
					<ea:datacontext id="dc" runat="server" TypeName="Soneta.Kasa.RaportESP,Soneta.Kasa" oncontextload="OnContextLoad"></ea:datacontext>
					<ea:DataLabel runat="server" id="dlRaport"></ea:DataLabel>
					<ea:DataLabel id="DataLabel4" runat="server" DataMember="Numer"></ea:DataLabel>
					<br>
					&nbsp;&nbsp;&nbsp; Ewidencja:<ea:datalabel runat="server" DataMember="Kasa" NonBreakSpace="True" id="Datalabel5x" Align="Left"></ea:datalabel><BR>
					&nbsp;&nbsp;&nbsp; Waluta:&nbsp;&nbsp;&nbsp;
					<ea:datalabel id="DataLabel5" runat="server" DataMember="Kasa.Waluta.Symbol"></ea:datalabel><br>
					&nbsp;&nbsp;&nbsp; Okres:&nbsp;&nbsp;&nbsp;&nbsp;
					<ea:datalabel id="DataLabel6x" runat="server" DataMember="Okres"></ea:datalabel>&nbsp;&nbsp;&nbsp;&nbsp;
					<br>
					<i>------------------------------------------------------------------------------</i><br>
					<ea:datalabel ID="IdPieczatka" runat="server" 
						LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
					<ea:datalabel id="DataLabel9" runat="server" DataMember="Session.Core.Config.Firma.AdresSiedziby.Linia1"
						LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
					<ea:datalabel id="DataLabel10" runat="server" DataMember="Session.Core.Config.Firma.AdresSiedziby.Linia2"
						LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
					&nbsp;&nbsp;&nbsp;&nbsp;NIP:
					<ea:datalabel id="DataLabel11" runat="server" DataMember="Session.Core.Config.Firma.Pieczątka.NIP"></ea:datalabel><BR>
					<I>------------------------------------------------------------------------------</I><br>
					<small>
						<ea:TextGrid id="TextGrid1" runat="server" DataMember="Zaplaty" RowTypeName="Soneta.Kasa.Zaplata,Soneta.Kasa"
							OnAfterRender="Grid1_AfterRender" OnBeforeRow="Grid1_BeforeRow">
							<Columns>
								<ea:GridColumn Width="4" DataMember="Lp" Caption="Lp."></ea:GridColumn>
								<ea:GridColumn Width="10" DataMember="DataDokumentu" Caption="Data"></ea:GridColumn>
								<ea:GridColumn Width="20" DataMember="NumerDokumentu" Caption="Numer" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Width="20" DataMember="Podmiot.Kod" Caption="Podmiot" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="Opis" ID="colOpis" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Center" DataMember="SposobZaplaty" Total="Info" Caption="Spos&#243;b"></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" HideZero="True"
									Format="{0:n}"></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" HideZero="True"
									Format="{0:n}"></ea:GridColumn>
							</Columns>
						</ea:TextGrid>
					</small><SMALL></SMALL>
				</P>
				<P><SMALL>
						<ea:TextGrid id="TextGrid2" runat="server" RowTypeName="Soneta.Kasa.Zaplata,Soneta.Kasa" OnAfterRender="Grid1_AfterRender"
							DESIGNTIMEDRAGDROP="402">
							<Columns>
								<ea:GridColumn Width="4" DataMember="#" Caption="Lp."></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Center" DataMember="Nazwa" Total="Info" Caption="Spos&#243;b"></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" HideZero="True"
									Format="{0:n}"></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" HideZero="True"
									Format="{0:n}"></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Right" DataMember="Saldo" Total="Sum" Caption="R&#243;żnica" HideZero="True"
									Format="{0:n}"></ea:GridColumn>
							</Columns>
						</ea:TextGrid></P>
				</SMALL>
				<P><SMALL>
						<ea:TextGrid id="TextGrid3" runat="server" RowTypeName="Soneta.Kasa.Zaplata,Soneta.Kasa" OnAfterRender="Grid1_AfterRender">
							<Columns>
								<ea:GridColumn Width="14" Align="Center" DataMember="Nazwa" Total="Info" Caption="Nazwa"></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" HideZero="True"
									Format="{0:n}"></ea:GridColumn>
								<ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" HideZero="True"
									Format="{0:n}"></ea:GridColumn>
							</Columns>
						</ea:TextGrid></SMALL></P>
				<P><SMALL>--------------------------------+-------------------------------+-------------------------------+--------------------------------<BR>
						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						Sporządził&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						Sprawdził&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Zatwierdził<BR>
						&nbsp;Data wydruku:
						<ea:DataLabel id="labelData" Align="Left" Bold="False" Runat="server" WidthChars="17"></ea:DataLabel>|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|<BR>
						&nbsp;Operator:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|&nbsp;&nbsp;&nbsp;&nbsp; ....................&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|&nbsp;&nbsp;&nbsp;&nbsp; ....................&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|&nbsp;&nbsp;&nbsp;&nbsp; ....................<BR>
						&nbsp;
						<ea:DataLabel id="labelOperator" Align="Left" Bold="False" Runat="server" WidthChars="31"></ea:DataLabel>|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						Podpis&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						Podpis&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Podpis<BR>
						--------------------------------+-------------------------------+-------------------------------+--------------------------------<BR>
					</SMALL><SMALL>
						<ea:DataLabel id="labelCopyright" runat="server" Align="Right" Bold="False" WidthChars="130"></ea:DataLabel>
					</SMALL>
					<ea:PageBreak id="PageBreak1" runat="server"></ea:PageBreak></P>
			</form>
		</font>
	</body>
</HTML>

